<?php

require_once("../../core/controllers/imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("../../core/controllers/imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'receipt';
        $this->shcontrollname = 'Receipt';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'pharmacy'; //controller name or tab name
        $active[1] = 'Receipt'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'show';
                break;
            case 'show':$active[2] = 'show';
                break;
            default :$active[2] = 'show';
                break;
        }
        $this->active = $active;



        //here will call all php pages
        require_once("../../core/controllers/_header.php");
        require_once("../../core/controllers/_sidebar.php");
        require_once("../../core/controllers/_leftsidebar.php");
        require_once("../../core/controllers/_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //call All Receipt
        $allreceipt = R::findAll('recepittmp');
        foreach ($allreceipt as $datasng) 
        {
            // doctor name
            $docName = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$datasng->doctor_id]);
            $datasng->namedoc = $docName['user_name'];
            
            
            $patientName = R::load('patients' , $datasng->patient_id);
            $datasng->patientname = $patientName->wifename;
        }

        // calling html files
        $this->smarty->assign('allreceipt', $allreceipt);
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('receipt/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //call All Receipt
        $allreceipt = R::findAll('recepittmp');
        foreach ($allreceipt as $datasng) 
        {
            // doctor name
            $docName = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$datasng->doctor_id]);
            $datasng->namedoc = $docName['user_name'];
            
            
            $patientName = R::load('patients' , $datasng->patient_id);
            $datasng->patientname = $patientName->wifename;
        }

        // calling html files
        $this->smarty->assign('allreceipt', $allreceipt);
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('receipt/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    ## Show all details receipt to cash

    public function showdetails() {

        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //get receipt by id
        $id = filter_input(INPUT_GET, 'id');
        $allreceipt = R::findOne('recepittmp', 'id = ?', [$id]);
        
        //get doctor name in this receipt
        $docName = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$allreceipt->doctor_id]);
        $allreceipt->namedoc = $docName['user_name'];
        
        //get patient name in this receipt
       $patientName = R::load('patients' , $allreceipt->patient_id);
        $allreceipt->patientname = $patientName->wifename;
        
        // get all drugs in this receipt
        $durgs = R::findAll('receiptdrugs', 'receipt_id = ?', [$allreceipt->id]);
        $datachecked = false ;
        foreach ($durgs as $drug) {
            $durgsdetails = R::findOne('drugs', 'id = ?', [$drug->drugs_id]);
            $drug->name = $durgsdetails->drugname;
            $drug->currentbalance = $durgsdetails->currentbalance;

            if ($drug->currentbalance < $drug->amount) {
                $datachecked = TRUE;
            }
        }



        $this->smarty->assign('durgs', $durgs);
        $this->smarty->assign('allreceipt', $allreceipt);
        $this->smarty->assign('datachecked', $datachecked);
        //calling html files
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('receipt/showdetails.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    ## This function to update drugs that cashing and minus it from drugs tbl

    public function updatereceipt() {
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        $id = filter_input(INPUT_POST, 'id');
        $durgs = R::findAll('receiptdrugs', 'receipt_id = ?', [$id]);

        foreach ($durgs as $drug) {

            $currentvalreceipt = R::findOne('drugs', 'id = ?', [$drug->drugs_id]);

            $before = $currentvalreceipt->currentbalance;
            $pharstorecash = R::dispense('pharmacystore');
            $pharstorecash->drug_id = $drug->drugs_id;
            $pharstorecash->amountbefore = $before;
            $pharstorecash->amountvary = $drug->amount;
            $pharstorecash->amountafter = $pharstorecash->amountbefore - $pharstorecash->amountvary;
            $pharstorecash->opdate = date('Y-m-d H:i:s');
            $pharstorecash->optype = 1;

            if ($pharstorecash->amountvary <= $before) {
                R::store($pharstorecash);
                $durgsreceipt = R::load('drugs', $currentvalreceipt->id);
                // if drug in receipt dosn't exist in tbl drugs
                if ($pharstorecash->drug_id != $durgsreceipt->id) {
                    continue;
                }
                $durgsreceipt->currentbalance = $pharstorecash->amountafter;
                R::store($durgsreceipt);
            }
        }
        $recstatus = filter_input(INPUT_POST, 'status');
        $update = R::load('recepittmp', $id);
        $update->status = $recstatus;
        try {

            R::store($update);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $ex) {

        }
    }
    
    
        public function update() 
    {
        ## check login
        autho::checkautho($this->hosturl);
        ## check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");       
        
        $obj = R::load($tablename, $id);
        $obj->$colname = $value;
        R::store($obj);

    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
