$(document).ready(function () {
    let hosturl = $('#hosturl').val();
    let patient_id = $('#patientId').val();

    $('#growth_add').click(function () {
        $.post(hosturl + '/controllers/growth_chart.php?ac=newRow', {patient_id: patient_id}, function (data) {
            $('#growth_container').prepend(data);
        });
    });

    $('body').on('change', '.calc_bmi', function () {
        let column_id = $(this).attr('data-id');
        let [weight, length, bmi] = [$('#weight_' + column_id).val(), $('#length_' + column_id).val(), $('#bmi_' + column_id)];
        if (length > 0) {
            let af_length = length / 100;
            let bmi_res = weight / (af_length * af_length);
            let bmi_calc = Math.ceil(bmi_res);
            bmi.val(bmi_calc).trigger("change");
        }
    })

    let ChartsFlotCharts = function () {
        return {
            initCharts: function () {

                if (!jQuery.plot) {
                    return;
                }

                function drawTooltipsChart(item_tag_id, previousPoint, plot) {
                    item_tag_id.bind("plothover", function (event, pos, item) {
                        if (item) {
                            if (previousPoint !== item.dataIndex) {
                                previousPoint = item.dataIndex;
                                $("#tooltip").remove();
                                var drawn_lines_content = '';
                                if (item.series.label === 'patient') {
                                    var x = item.datapoint[0].toFixed(2),
                                        y = item.datapoint[1].toFixed(2);
                                    drawn_lines_content = item.series.label + " of " + x + " = " + y;
                                } else {
                                    var point_index = item.dataIndex;
                                    var i, dataset = plot.getData();
                                    drawn_lines_content = 'Select point';
                                    for (i = 0; i < dataset.length; ++i) {
                                        if (dataset[i].data[point_index]) {
                                            if (dataset[i].label !== 'patient') {
                                                var line_x = dataset[i].data[point_index][0].toFixed(2),
                                                    line_y = dataset[i].data[point_index][1].toFixed(2);
                                                drawn_lines_content += '<br/>' + dataset[i].label + " : " + line_y;
                                            }
                                        }
                                    }
                                }
                                showTooltip(item.pageX, item.pageY, drawn_lines_content);
                            }
                        } else {
                            $("#tooltip").remove();
                            previousPoint = null;
                        }
                    });
                }

                function showTooltip(x, y, contents) {
                    $('<div id="tooltip">' + contents + '</div>').css({
                        position: 'absolute',
                        display: 'none',
                        top: y + 5,
                        left: x + 15,
                        border: '1px solid #333',
                        padding: '4px',
                        color: '#fff',
                        'border-radius': '3px',
                        'background-color': '#333',
                        opacity: 0.80
                    }).appendTo("body").fadeIn(200);
                }

                function cdcBoysHeight20() {
                    let item_tag_id = $("#cdc_boy_height_20");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "3rd", data: [
                                    [24 / 12, 79.91084], [36.5 / 12, 88.37864], [48.5 / 12, 94.59361], [60.5 / 12, 100.3318], [72.5 / 12, 106.1048],
                                    [84.5 / 12, 111.9459], [96.5 / 12, 117.5], [108.5 / 12, 122.4034], [120.5 / 12, 126.6678], [132.5 / 12, 130.8127],
                                    [144.5 / 12, 135.6621], [156.5 / 12, 141.7345], [168.5 / 12, 148.5284], [180.5 / 12, 154.6056], [192.5 / 12, 158.845],
                                    [204.5 / 12, 161.2733], [216.5 / 12, 162.5011], [228.5 / 12, 163.0793], [240 / 12, 163.3333]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "5th", data: [
                                    [24 / 12, 80.72977], [36.5 / 12, 89.20473], [48.5 / 12, 95.5807], [60.5 / 12, 101.4523], [72.5 / 12, 107.3099],
                                    [84.5 / 12, 113.1991], [96.5 / 12, 118.8053], [108.5 / 12, 123.7928], [120.5 / 12, 128.1625], [132.5 / 12, 132.399],
                                    [144.5 / 12, 137.3326], [156.5 / 12, 143.5608], [168.5 / 12, 150.5461], [180.5 / 12, 156.6566], [192.5 / 12, 160.7802],
                                    [204.5 / 12, 163.086], [216.5 / 12, 164.2424], [228.5 / 12, 164.7915], [240 / 12, 165.0389]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [24 / 12, 81.99171], [36.5 / 12, 90.49789], [48.5 / 12, 97.10407], [60.5 / 12, 103.1712], [72.5 / 12, 109.1619],
                                    [84.5 / 12, 115.1356], [96.5 / 12, 120.8305], [108.5 / 12, 125.9501], [120.5 / 12, 130.4809], [132.5 / 12, 134.8608],
                                    [144.5 / 12, 139.928], [156.5 / 12, 146.3813], [168.5 / 12, 153.6181], [180.5 / 12, 159.7529], [192.5 / 12, 163.7104],
                                    [204.5 / 12, 165.8491], [216.5 / 12, 166.9094], [228.5 / 12, 167.4199], [240 / 12, 167.6593]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "25th", data: [
                                    [24 / 12, 84.10289], [36.5 / 12, 92.71756], [48.5 / 12, 99.65875], [60.5 / 12, 106.0265], [72.5 / 12, 112.2469],
                                    [84.5 / 12, 118.3893], [96.5 / 12, 124.2562], [108.5 / 12, 129.6035], [120.5 / 12, 134.4008], [132.5 / 12, 139.0262],
                                    [144.5 / 12, 144.3277], [156.5 / 12, 151.1165], [168.5 / 12, 158.6615], [180.5 / 12, 164.7713], [192.5 / 12, 168.4805],
                                    [204.5 / 12, 170.3931], [216.5 / 12, 171.3282], [228.5 / 12, 171.791], [240 / 12, 172.0227]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [24 / 12, 86.4522], [36.5 / 12, 95.27359], [48.5 / 12, 102.5105], [60.5 / 12, 109.1751], [72.5 / 12, 115.6609],
                                    [84.5 / 12, 122.0305], [96.5 / 12, 128.1237], [108.5 / 12, 133.7345], [120.5 / 12, 138.8234], [132.5 / 12, 143.7304],
                                    [144.5 / 12, 149.3088], [156.5 / 12, 156.4099], [168.5 / 12, 164.1418], [180.5 / 12, 170.1393], [192.5 / 12, 173.6101],
                                    [204.5 / 12, 175.341], [216.5 / 12, 176.185], [228.5 / 12, 176.6179], [240 / 12, 176.8492]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "75th", data: [
                                    [24 / 12, 88.80525], [36.5 / 12, 97.9287], [48.5 / 12, 105.3759], [60.5 / 12, 112.2998], [72.5 / 12, 119.0611],
                                    [84.5 / 12, 125.6987], [96.5 / 12, 132.0559], [108.5 / 12, 137.9414], [120.5 / 12, 143.3168], [132.5 / 12, 148.5147],
                                    [144.5 / 12, 154.3881], [156.5 / 12, 161.7364], [168.5 / 12, 169.5022], [180.5 / 12, 175.3105], [192.5 / 12, 178.5762],
                                    [204.5 / 12, 180.1896], [216.5 / 12, 180.9889], [228.5 / 12, 181.4147], [240 / 12, 181.6538]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [24 / 12, 90.92619], [36.5 / 12, 100.4072], [48.5 / 12, 107.9665], [60.5 / 12, 115.0924], [72.5 / 12, 122.1101],
                                    [84.5 / 12, 129.023], [96.5 / 12, 135.6504], [108.5 / 12, 141.793], [120.5 / 12, 147.4214], [132.5 / 12, 152.8894],
                                    [144.5 / 12, 159.0439], [156.5 / 12, 166.5581], [168.5 / 12, 174.2313], [180.5 / 12, 179.8124], [192.5 / 12, 182.9179],
                                    [204.5 / 12, 184.4741], [216.5 / 12, 185.2692], [228.5 / 12, 185.7073], [240 / 12, 185.9599]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "95th", data: [
                                    [24 / 12, 92.19688], [36.5 / 12, 101.9324], [48.5 / 12, 109.522], [60.5 / 12, 116.755], [72.5 / 12, 123.9297],
                                    [84.5 / 12, 131.0226], [96.5 / 12, 137.8267], [108.5 / 12, 144.1278], [120.5 / 12, 149.9053], [132.5 / 12, 155.5386],
                                    [144.5 / 12, 161.8686], [156.5 / 12, 169.4561], [168.5 / 12, 177.0206], [180.5 / 12, 182.4429], [192.5 / 12, 185.4623],
                                    [204.5 / 12, 187.004], [216.5 / 12, 187.812], [228.5 / 12, 188.2653], [240 / 12, 188.529]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "97th", data: [
                                    [24 / 12, 93.02265], [36.5 / 12, 102.9402], [48.5 / 12, 110.5342], [60.5 / 12, 117.8314], [72.5 / 12, 125.1095],
                                    [84.5 / 12, 132.3253], [96.5 / 12, 139.2502], [108.5 / 12, 145.656], [120.5 / 12, 151.5294], [132.5 / 12, 157.2715],
                                    [144.5 / 12, 163.7185], [156.5 / 12, 171.343], [168.5 / 12, 178.8165], [180.5 / 12, 184.127], [192.5 / 12, 187.0941],
                                    [204.5 / 12, 188.6338], [216.5 / 12, 189.456], [228.5 / 12, 189.9224], [240 / 12, 190.1943]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#cdc_height_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#107ad1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 19, min: 2, max: 20, axisLabel: 'Age (yr)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {tickColor: "#eee", ticks: 23, min: 79, max: 191, axisLabel: 'Height (CM)'},
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function cdcGirlsHeight20() {
                    let item_tag_id = $('#cdc_girl_height_20');
                    if (item_tag_id.size() !== 1) {
                        return;
                    }

                    var plot = $.plot(item_tag_id, [
                            {
                                label: "3rd", data: [
                                    [24 / 12, 78.43754], [36.5 / 12, 86.90307], [48.5 / 12, 93.06862], [60.5 / 12, 99.35047], [72.5 / 12, 105.7615],
                                    [84.5 / 12, 111.8684], [96.5 / 12, 117.2737], [108.5 / 12, 121.8537], [120.5 / 12, 125.9599], [132.5 / 12, 130.7217],
                                    [144.5 / 12, 137.4381], [156.5 / 12, 144.2287], [168.5 / 12, 148.1173], [180.5 / 12, 149.7416], [192.5 / 12, 150.4209],
                                    [204.5 / 12, 150.7491], [216.5 / 12, 150.9319], [228.5 / 12, 151.043], [240 / 12, 151.1112]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "5th", data: [
                                    [24 / 12, 79.25982], [36.5 / 12, 87.80528], [48.5 / 12, 94.04022], [60.5 / 12, 100.3891], [72.5 / 12, 106.8701],
                                    [84.5 / 12, 113.0546], [96.5 / 12, 118.5443], [108.5 / 12, 123.2186], [120.5 / 12, 127.4524], [132.5 / 12, 132.4013],
                                    [144.5 / 12, 139.2236], [156.5 / 12, 145.8894], [168.5 / 12, 149.6655], [180.5 / 12, 151.2611], [192.5 / 12, 151.9418],
                                    [204.5 / 12, 152.2764], [216.5 / 12, 152.4647], [228.5 / 12, 152.5798], [240 / 12, 152.6507]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [24 / 12, 80.52476], [36.5 / 12, 89.20285], [48.5 / 12, 95.55164], [60.5 / 12, 102.0109], [72.5 / 12, 108.605],
                                    [84.5 / 12, 114.9112], [96.5 / 12, 120.53], [108.5 / 12, 125.3478], [120.5 / 12, 129.7752], [132.5 / 12, 134.9983],
                                    [144.5 / 12, 141.9594], [156.5 / 12, 148.4376], [168.5 / 12, 152.0508], [180.5 / 12, 153.604], [192.5 / 12, 154.2854],
                                    [204.5 / 12, 154.6281], [216.5 / 12, 154.8235], [228.5 / 12, 154.9438], [240 / 12, 155.0181]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "25th", data: [
                                    [24 / 12, 82.63524], [36.5 / 12, 91.56066], [48.5 / 12, 98.11905], [60.5 / 12, 104.7829], [72.5 / 12, 111.5812],
                                    [84.5 / 12, 118.0964], [96.5 / 12, 123.9285], [108.5 / 12, 128.9808], [120.5 / 12, 133.7239], [132.5 / 12, 139.3664],
                                    [144.5 / 12, 146.4958], [156.5 / 12, 152.6721], [168.5 / 12, 156.0401], [180.5 / 12, 157.5271], [192.5 / 12, 158.2061],
                                    [204.5 / 12, 158.5577], [216.5 / 12, 158.7612], [228.5 / 12, 158.8872], [240 / 12, 158.9651]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [24 / 12, 84.97556], [36.5 / 12, 94.21336], [48.5 / 12, 101.0339], [60.5 / 12, 107.9566], [72.5 / 12, 115.0055],
                                    [84.5 / 12, 121.7617], [96.5 / 12, 127.8263], [108.5 / 12, 133.1304], [120.5 / 12, 138.2112], [132.5 / 12, 144.2609],
                                    [144.5 / 12, 151.4866], [156.5 / 12, 157.3437], [168.5 / 12, 160.4777], [180.5 / 12, 161.898], [192.5 / 12, 162.569],
                                    [204.5 / 12, 162.9238], [216.5 / 12, 163.1308], [228.5 / 12, 163.259], [240 / 12, 163.3383]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "75th", data: [
                                    [24 / 12, 87.31121], [36.5 / 12, 96.90071], [48.5 / 12, 104.0154], [60.5 / 12, 111.2321], [72.5 / 12, 118.5588],
                                    [84.5 / 12, 125.5655], [96.5 / 12, 131.8567], [108.5 / 12, 137.4018], [120.5 / 12, 142.8051], [132.5 / 12, 149.1984],
                                    [144.5 / 12, 156.428], [156.5 / 12, 161.9818], [168.5 / 12, 164.9206], [180.5 / 12, 166.2812], [192.5 / 12, 166.9388],
                                    [204.5 / 12, 167.29], [216.5 / 12, 167.4948], [228.5 / 12, 167.6211], [240 / 12, 167.6987]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [24 / 12, 89.40951], [36.5 / 12, 99.34899], [48.5 / 12, 106.7567], [60.5 / 12, 114.2701], [72.5 / 12, 121.8718],
                                    [84.5 / 12, 129.1127], [96.5 / 12, 135.6015], [108.5 / 12, 141.3532], [120.5 / 12, 147.0322], [132.5 / 12, 153.6783],
                                    [144.5 / 12, 160.8353], [156.5 / 12, 166.1289], [168.5 / 12, 168.9239], [180.5 / 12, 170.2366], [192.5 / 12, 170.8775],
                                    [204.5 / 12, 171.2198], [216.5 / 12, 171.418], [228.5 / 12, 171.5391], [240 / 12, 171.6129]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "95th", data: [
                                    [24 / 12, 90.66355], [36.5 / 12, 100.8276], [48.5 / 12, 108.4238], [60.5 / 12, 116.1301], [72.5 / 12, 123.9086],
                                    [84.5 / 12, 131.2936], [96.5 / 12, 137.8975], [108.5 / 12, 143.7674], [120.5 / 12, 149.6044], [132.5 / 12, 156.3755],
                                    [144.5 / 12, 163.4555], [156.5 / 12, 168.5987], [168.5 / 12, 171.3216], [180.5 / 12, 172.6084], [192.5 / 12, 173.2373],
                                    [204.5 / 12, 173.5716], [216.5 / 12, 173.7638], [228.5 / 12, 173.8802], [240 / 12, 173.9507]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "97th", data: [
                                    [24 / 12, 91.47729], [36.5 / 12, 101.7931], [48.5 / 12, 109.5172], [60.5 / 12, 117.3552], [72.5 / 12, 125.2536],
                                    [84.5 / 12, 132.7338], [96.5 / 12, 139.411], [108.5 / 12, 145.3555], [120.5 / 12, 151.292], [132.5 / 12, 158.1335],
                                    [144.5 / 12, 165.1503], [156.5 / 12, 170.1979], [168.5 / 12, 172.8796], [180.5 / 12, 174.1505], [192.5 / 12, 174.7708],
                                    [204.5 / 12, 175.099], [216.5 / 12, 175.2864], [228.5 / 12, 175.3993], [240 / 12, 175.4671]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#cdc_height_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 3, lineWidth: 1}, lines: {lineWidth: 3}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#c410d1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 19, min: 2, max: 20, axisLabel: 'Age (yr)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {tickColor: "#eee", ticks: 20, min: 78, max: 176, axisLabel: 'Height (CM)'},
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function cdcBoysWeight20() {
                    let item_tag_id = $("#cdc_boy_weight_20");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "3rd", data: [
                                    [24 / 12, 10.38209], [36.5 / 12, 11.81842], [48.5 / 12, 13.29111], [60.5 / 12, 14.85692], [72.5 / 12, 16.5037],
                                    [84.5 / 12, 18.25535], [96.5 / 12, 20.11467], [108.5 / 12, 22.07685], [120.5 / 12, 24.19264], [132.5 / 12, 26.59626],
                                    [144.5 / 12, 29.47257], [156.5 / 12, 32.96852], [168.5 / 12, 37.07331], [180.5 / 12, 41.52175], [192.5 / 12, 45.79301],
                                    [204.5 / 12, 49.28662], [216.5 / 12, 51.69086], [228.5 / 12, 53.21739], [240 / 12, 54.00392]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "5th", data: [
                                    [24 / 12, 10.64009], [36.5 / 12, 12.09962], [48.5 / 12, 13.61006], [60.5 / 12, 15.23202], [72.5 / 12, 16.93704],
                                    [84.5 / 12, 18.74211], [96.5 / 12, 20.66168], [108.5 / 12, 22.70876], [120.5 / 12, 24.94392], [132.5 / 12, 27.50031],
                                    [144.5 / 12, 30.55162], [156.5 / 12, 34.22353], [168.5 / 12, 38.47571], [180.5 / 12, 43.01506], [192.5 / 12, 47.31593],
                                    [204.5 / 12, 50.80971], [216.5 / 12, 53.2274], [228.5 / 12, 54.80066], [240 / 12, 55.66071]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [24 / 12, 11.1149], [36.5 / 12, 12.55436], [48.5 / 12, 14.13086], [60.5 / 12, 15.84814], [72.5 / 12, 17.65285],
                                    [84.5 / 12, 19.55136], [96.5 / 12, 21.57637], [108.5 / 12, 23.76955], [120.5 / 12, 26.20745], [132.5 / 12, 29.02052],
                                    [144.5 / 12, 32.36224], [156.5 / 12, 36.32176], [168.5 / 12, 40.81133], [180.5 / 12, 45.49646], [192.5 / 12, 49.84727],
                                    [204.5 / 12, 53.34544], [216.5 / 12, 55.78731], [228.5 / 12, 57.43409], [240 / 12, 58.41105]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "25th", data: [
                                    [24 / 12, 11.85182], [36.5 / 12, 13.37875], [48.5 / 12, 15.09163], [60.5 / 12, 16.99698], [72.5 / 12, 19.00147],
                                    [84.5 / 12, 21.0946], [96.5 / 12, 23.34005], [108.5 / 12, 25.82993], [120.5 / 12, 28.66894], [132.5 / 12, 31.97868],
                                    [144.5 / 12, 35.86837], [156.5 / 12, 40.35506], [168.5 / 12, 45.26849], [180.5 / 12, 50.21378], [192.5 / 12, 54.66505],
                                    [204.5 / 12, 58.18918], [216.5 / 12, 60.68521], [228.5 / 12, 62.4568], [240 / 12, 63.63611]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [24 / 12, 12.74154], [36.5 / 12, 14.40263], [48.5 / 12, 16.31677], [60.5 / 12, 18.48592], [72.5 / 12, 20.7777],
                                    [84.5 / 12, 23.16742], [96.5 / 12, 25.75257], [108.5 / 12, 28.6813], [120.5 / 12, 32.08799], [132.5 / 12, 36.07263],
                                    [144.5 / 12, 40.67444], [156.5 / 12, 45.81336], [168.5 / 12, 51.23096], [180.5 / 12, 56.49096], [192.5 / 12, 61.09537],
                                    [204.5 / 12, 64.69961], [216.5 / 12, 67.28993], [228.5 / 12, 69.19467], [240 / 12, 70.59761]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "75th", data: [
                                    [24 / 12, 13.71386], [36.5 / 12, 15.55987], [48.5 / 12, 17.74767], [60.5 / 12, 20.26086], [72.5 / 12, 22.93978],
                                    [84.5 / 12, 25.75894], [96.5 / 12, 28.84718], [108.5 / 12, 32.39734], [120.5 / 12, 36.55851], [132.5 / 12, 41.38377],
                                    [144.5 / 12, 46.81253], [156.5 / 12, 52.65558], [168.5 / 12, 58.5908], [180.5 / 12, 64.19328], [192.5 / 12, 69.03038],
                                    [204.5 / 12, 72.82297], [216.5 / 12, 75.57503], [228.5 / 12, 77.5858], [240 / 12, 79.18111]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [24 / 12, 14.66716], [36.5 / 12, 16.73623], [48.5 / 12, 19.25695], [60.5 / 12, 22.17744], [72.5 / 12, 25.33302],
                                    [84.5 / 12, 28.72538], [96.5 / 12, 32.51025], [108.5 / 12, 36.88596], [120.5 / 12, 41.96894], [132.5 / 12, 47.72519],
                                    [144.5 / 12, 53.97661], [156.5 / 12, 60.448], [168.5 / 12, 66.81785], [180.5 / 12, 72.75113], [192.5 / 12, 77.92233],
                                    [204.5 / 12, 82.06741], [216.5 / 12, 85.0764], [228.5 / 12, 87.12008], [240 / 12, 88.80644]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "95th", data: [
                                    [24 / 12, 15.2763], [36.5 / 12, 17.51093], [48.5 / 12, 20.28339], [60.5 / 12, 23.50833], [72.5 / 12, 27.03308],
                                    [84.5 / 12, 30.90178], [96.5 / 12, 35.28955], [108.5 / 12, 40.36069], [120.5 / 12, 46.15753], [132.5 / 12, 52.55602],
                                    [144.5 / 12, 59.30357], [156.5 / 12, 66.10359], [168.5 / 12, 72.68681], [180.5 / 12, 78.82659], [192.5 / 12, 84.29229],
                                    [204.5 / 12, 88.79528], [216.5 / 12, 92.04765], [228.5 / 12, 94.05261], [240 / 12, 95.71431]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "97th", data: [
                                    [24 / 12, 15.68841], [36.5 / 12, 18.0457], [48.5 / 12, 21.00793], [60.5 / 12, 24.46169], [72.5 / 12, 28.27115],
                                    [84.5 / 12, 32.52599], [96.5 / 12, 37.41935], [108.5 / 12, 43.06589], [120.5 / 12, 49.41515], [132.5 / 12, 56.26029],
                                    [144.5 / 12, 63.30853], [156.5 / 12, 70.27738], [168.5 / 12, 76.9639], [180.5 / 12, 83.24017], [192.5 / 12, 88.95303],
                                    [204.5 / 12, 93.77917], [216.5 / 12, 97.24564], [228.5 / 12, 99.18615], [240 / 12, 100.7784]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#cdc_weight_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#107ad1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 19, min: 2, max: 20, axisLabel: 'Age (yr)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {tickColor: "#eee", ticks: 21, min: 10, max: 102, axisLabel: 'Weight (KG)'},
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function cdcGirlsWeight20() {
                    let item_tag_id = $("#cdc_girl_weight_20");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "3rd", data: [
                                    [24 / 12, 9.985668], [36.5 / 12, 11.38824], [48.5 / 12, 12.77432], [60.5 / 12, 14.34277], [72.5 / 12, 16.01186],
                                    [84.5 / 12, 17.72858], [96.5 / 12, 19.54481], [108.5 / 12, 21.58837], [120.5 / 12, 23.99143], [132.5 / 12, 26.81859],
                                    [144.5 / 12, 30.0176], [156.5 / 12, 33.40617], [168.5 / 12, 36.70144], [180.5 / 12, 39.59012], [192.5 / 12, 41.82734],
                                    [204.5 / 12, 43.33646], [216.5 / 12, 44.24715], [228.5 / 12, 44.79521], [240 / 12, 45.04655]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "5th", data: [
                                    [24 / 12, 10.21027], [36.5 / 12, 11.65542], [48.5 / 12, 13.09012], [60.5 / 12, 14.70924], [72.5 / 12, 16.43608],
                                    [84.5 / 12, 18.22805], [96.5 / 12, 20.14535], [108.5 / 12, 22.31677], [120.5 / 12, 24.86516], [132.5 / 12, 27.83564],
                                    [144.5 / 12, 31.15094], [156.5 / 12, 34.60715], [168.5 / 12, 37.91342], [180.5 / 12, 40.76839], [192.5 / 12, 42.95649],
                                    [204.5 / 12, 44.4355], [216.5 / 12, 45.3602], [228.5 / 12, 45.97009], [240 / 12, 46.28963]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [24 / 12, 10.57373], [36.5 / 12, 12.09259], [48.5 / 12, 13.61116], [60.5 / 12, 15.31758], [72.5 / 12, 17.14327],
                                    [84.5 / 12, 19.063], [96.5 / 12, 21.15111], [108.5 / 12, 23.53813], [120.5 / 12, 26.33132], [132.5 / 12, 29.54321],
                                    [144.5 / 12, 33.05496], [156.5 / 12, 36.62688], [168.5 / 12, 39.95467], [180.5 / 12, 42.75627], [192.5 / 12, 44.8643],
                                    [204.5 / 12, 46.29382], [216.5 / 12, 47.24158], [228.5 / 12, 47.9528], [240 / 12, 48.38346]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "25th", data: [
                                    [24 / 12, 11.23357], [36.5 / 12, 12.90222], [48.5 / 12, 14.59093], [60.5 / 12, 16.47471], [72.5 / 12, 18.49904],
                                    [84.5 / 12, 20.67168], [96.5 / 12, 23.09446], [108.5 / 12, 25.90167], [120.5 / 12, 29.17072], [132.5 / 12, 32.8523],
                                    [144.5 / 12, 36.7495], [156.5 / 12, 40.55564], [168.5 / 12, 43.94012], [180.5 / 12, 46.65445], [192.5 / 12, 48.61968],
                                    [204.5 / 12, 49.95916], [216.5 / 12, 50.95014], [228.5 / 12, 51.8472], [240 / 12, 52.47876]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [24 / 12, 12.05504], [36.5 / 12, 13.94108], [48.5 / 12, 15.87824], [60.5 / 12, 18.02314], [72.5 / 12, 20.33636],
                                    [84.5 / 12, 22.86804], [96.5 / 12, 25.75702], [108.5 / 12, 29.14291], [120.5 / 12, 33.06392], [132.5 / 12, 37.39089],
                                    [144.5 / 12, 41.82798], [156.5 / 12, 45.98369], [168.5 / 12, 49.49075], [180.5 / 12, 52.13568], [192.5 / 12, 53.94544],
                                    [204.5 / 12, 55.18217], [216.5 / 12, 56.2297], [228.5 / 12, 57.35176], [240 / 12, 58.21897]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "75th", data: [
                                    [24 / 12, 12.98667], [36.5 / 12, 15.16452], [48.5 / 12, 17.44149], [60.5 / 12, 19.95048], [72.5 / 12, 22.66294],
                                    [84.5 / 12, 25.67549], [96.5 / 12, 29.17046], [108.5 / 12, 33.29393], [120.5 / 12, 38.03878], [132.5 / 12, 43.18655],
                                    [144.5 / 12, 48.33396], [156.5 / 12, 52.99745], [168.5 / 12, 56.76423], [180.5 / 12, 59.44404], [192.5 / 12, 61.16241],
                                    [204.5 / 12, 62.32761], [216.5 / 12, 63.4432], [228.5 / 12, 64.77838], [240 / 12, 65.85238]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [24 / 12, 13.93766], [36.5 / 12, 16.46789], [48.5 / 12, 19.16858], [60.5 / 12, 22.14604], [72.5 / 12, 25.37145],
                                    [84.5 / 12, 28.97979], [96.5 / 12, 33.19435], [108.5 / 12, 38.16762], [120.5 / 12, 43.85001], [132.5 / 12, 49.9428],
                                    [144.5 / 12, 55.95048], [156.5 / 12, 61.31281], [168.5 / 12, 65.57527], [180.5 / 12, 68.54877], [192.5 / 12, 70.40499],
                                    [204.5 / 12, 71.63707], [216.5 / 12, 72.82563], [228.5 / 12, 74.23744], [240 / 12, 75.35165]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "95th", data: [
                                    [24 / 12, 14.56636], [36.5 / 12, 17.36244], [48.5 / 12, 20.39409], [60.5 / 12, 23.75024], [72.5 / 12, 27.39274],
                                    [84.5 / 12, 31.47049], [96.5 / 12, 36.22699], [108.5 / 12, 41.81885], [120.5 / 12, 48.17501], [132.5 / 12, 54.95703],
                                    [144.5 / 12, 61.62701], [156.5 / 12, 67.59448], [168.5 / 12, 72.39275], [180.5 / 12, 75.82805], [192.5 / 12, 78.05211],
                                    [204.5 / 12, 79.51506], [216.5 / 12, 80.75172], [228.5 / 12, 82.02139], [240 / 12, 82.95375]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "97th", data: [
                                    [24 / 12, 15.68841], [36.5 / 12, 17.99807], [48.5 / 12, 21.28616], [60.5 / 12, 24.94401], [72.5 / 12, 28.92162],
                                    [84.5 / 12, 33.36833], [96.5 / 12, 38.53537], [108.5 / 12, 44.58226], [120.5 / 12, 51.42913], [132.5 / 12, 58.72013],
                                    [144.5 / 12, 65.90103], [156.5 / 12, 72.37633], [168.5 / 12, 77.68817], [180.5 / 12, 81.6483], [192.5 / 12, 84.36639],
                                    [204.5 / 12, 86.16706], [216.5 / 12, 87.43462], [228.5 / 12, 88.42066], [240 / 12, 89.04485]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#cdc_weight_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#c410d1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 19, min: 2, max: 20, axisLabel: 'Age (yr)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {tickColor: "#eee", ticks: 21, min: 9, max: 90, axisLabel: 'Weight (KG)'},
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function cdcBoysBMI20() {
                    let item_tag_id = $("#cdc_boy_bmi_20");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "3rd", data: [
                                    [24 / 12, 14.52095], [36.5 / 12, 14.12223], [48.5 / 12, 13.83877], [60.5 / 12, 13.656], [72.5 / 12, 13.55435], [84.5 / 12, 13.52874], [96.5 / 12, 13.58604], [108.5 / 12, 13.73182], [120.5 / 12, 13.96673], [132.5 / 12, 14.28678],
                                    [144.5 / 12, 14.68398], [156.5 / 12, 15.14683], [168.5 / 12, 15.66076], [180.5 / 12, 16.20844], [192.5 / 12, 16.77038], [204.5 / 12, 17.32548], [216.5 / 12, 17.8515], [228.5 / 12, 18.32459], [240.5 / 12, 18.71706]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "5th", data: [
                                    [24 / 12, 14.73732], [36.5 / 12, 14.32851], [48.5 / 12, 14.03296], [60.5 / 12, 13.83855], [72.5 / 12, 13.73624], [84.5 / 12, 13.72113], [96.5 / 12, 13.79575], [108.5 / 12, 13.96212], [120.5 / 12, 14.21866], [132.5 / 12, 14.56001],
                                    [144.5 / 12, 14.97745], [156.5 / 12, 15.45918], [168.5 / 12, 15.99065], [180.5 / 12, 16.55481], [192.5 / 12, 17.1325], [204.5 / 12, 17.70284], [216.5 / 12, 18.24349], [228.5 / 12, 18.73019], [240.5 / 12, 19.1354]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [24 / 12, 15.09033], [36.5 / 12, 14.66086], [48.5 / 12, 14.34695], [60.5 / 12, 14.1378], [72.5 / 12, 14.03772], [84.5 / 12, 14.04216], [96.5 / 12, 14.14712], [108.5 / 12, 14.34903], [120.5 / 12, 14.6426], [132.5 / 12, 15.02022],
                                    [144.5 / 12, 15.47187], [156.5 / 12, 15.9852], [168.5 / 12, 16.54568], [180.5 / 12, 17.1367], [192.5 / 12, 17.73974], [204.5 / 12, 18.33444], [216.5 / 12, 18.89854], [228.5 / 12, 19.40766], [240.5 / 12, 19.83489]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "25th", data: [
                                    [24 / 12, 15.74164], [36.5 / 12, 15.26016], [48.5 / 12, 14.91694], [60.5 / 12, 14.69504], [72.5 / 12, 14.6112], [84.5 / 12, 14.66082], [96.5 / 12, 14.82965], [108.5 / 12, 15.10433], [120.5 / 12, 15.4727], [132.5 / 12, 15.92268],
                                    [144.5 / 12, 16.44158], [156.5 / 12, 17.01583], [168.5 / 12, 17.63086], [180.5 / 12, 18.27093], [192.5 / 12, 18.919], [204.5 / 12, 19.55629], [216.5 / 12, 20.1619], [228.5 / 12, 20.71283], [240.5 / 12, 21.18526]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [24 / 12, 16.57503], [36.5 / 12, 16.0003], [48.5 / 12, 15.62817], [60.5 / 12, 15.41914], [72.5 / 12, 15.38353], [84.5 / 12, 15.51287], [96.5 / 12, 15.78231], [108.5 / 12, 16.16712], [120.5 / 12, 16.64614], [132.5 / 12, 17.20089],
                                    [144.5 / 12, 17.81463], [156.5 / 12, 18.4718], [168.5 / 12, 19.15759], [180.5 / 12, 19.85766], [192.5 / 12, 20.55765], [204.5 / 12, 21.24248], [216.5 / 12, 21.89587], [228.5 / 12, 22.50072], [240.5 / 12, 23.04138]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "75th", data: [
                                    [24 / 12, 17.55719], [36.5 / 12, 16.83376], [48.5 / 12, 16.4397], [60.5 / 12, 16.29148], [72.5 / 12, 16.36346], [84.5 / 12, 16.63112], [96.5 / 12, 17.05799], [108.5 / 12, 17.60683], [120.5 / 12, 18.24521], [132.5 / 12, 18.94588],
                                    [144.5 / 12, 19.68614], [156.5 / 12, 20.44731], [168.5 / 12, 21.21433], [180.5 / 12, 21.97532], [192.5 / 12, 22.72115], [204.5 / 12, 23.4449], [216.5 / 12, 24.14166], [228.5 / 12, 24.80919], [240.5 / 12, 25.44978]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "85th", data: [
                                    [24 / 12, 18.16219], [36.5 / 12, 17.32627], [48.5 / 12, 16.92501], [60.5 / 12, 16.84076], [72.5 / 12, 17.01418], [84.5 / 12, 17.40122], [96.5 / 12, 17.95575], [108.5 / 12, 18.63222], [120.5 / 12, 19.39041], [132.5 / 12, 20.19667],
                                    [144.5 / 12, 21.02386], [156.5 / 12, 21.85104], [168.5 / 12, 22.66325], [180.5 / 12, 23.45117], [192.5 / 12, 24.21087], [204.5 / 12, 24.94362], [216.5 / 12, 25.65601], [228.5 / 12, 26.36054], [240.5 / 12, 27.07645]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [24 / 12, 18.60948], [36.5 / 12, 17.68022], [48.5 / 12, 17.27661], [60.5 / 12, 17.25344], [72.5 / 12, 17.52335], [84.5 / 12, 18.02183], [96.5 / 12, 18.69225], [108.5 / 12, 19.48149], [120.5 / 12, 20.3427], [132.5 / 12, 21.23679],
                                    [144.5 / 12, 22.1329], [156.5 / 12, 23.00842], [168.5 / 12, 23.84887], [180.5 / 12, 24.64778], [192.5 / 12, 25.40668], [204.5 / 12, 26.13515], [216.5 / 12, 26.8512], [228.5 / 12, 27.58159], [240.5 / 12, 28.36174]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "95th", data: [
                                    [24 / 12, 19.33801], [36.5 / 12, 18.23842], [48.5 / 12, 17.83614], [60.5 / 12, 17.93893], [72.5 / 12, 18.41421], [84.5 / 12, 19.15236], [96.5 / 12, 20.06793], [108.5 / 12, 21.08893], [120.5 / 12, 22.15409], [132.5 / 12, 23.21358],
                                    [144.5 / 12, 24.22985], [156.5 / 12, 25.17811], [168.5 / 12, 26.04662], [180.5 / 12, 26.83688], [192.5 / 12, 27.56393], [204.5 / 12, 28.25676], [216.5 / 12, 28.95862], [228.5 / 12, 29.72674], [240.5 / 12, 30.63106]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "97th", data: [
                                    [24 / 12, 19.85986], [36.5 / 12, 18.62449], [48.5 / 12, 18.22694], [60.5 / 12, 18.44112], [72.5 / 12, 19.10882], [84.5 / 12, 20.08052], [96.5 / 12, 21.23532], [108.5 / 12, 22.47666], [120.5 / 12, 23.72696], [132.5 / 12, 24.9263],
                                    [144.5 / 12, 26.03234], [156.5 / 12, 27.02054], [168.5 / 12, 27.88441], [180.5 / 12, 28.63575], [192.5 / 12, 29.30493], [204.5 / 12, 29.94097], [216.5 / 12, 30.6114], [228.5 / 12, 31.40152], [240.5 / 12, 32.41344]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#cdc_bmi_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#107ad1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 20, min: 2, max: 21, axisLabel: 'Age (yr)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 21, min: 13, max: 33, axisLabel: 'BMI (KG / m2)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function cdcGirlsBMI20() {
                    let item_tag_id = $("#cdc_girl_bmi_20");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "3rd", data: [
                                    [24 / 12, 14.14735], [36.5 / 12, 13.8023], [48.5 / 12, 13.53635], [60.5 / 12, 13.34252], [72.5 / 12, 13.23345], [84.5 / 12, 13.21816], [96.5 / 12, 13.29966], [108.5 / 12, 13.4759], [120.5 / 12, 13.74074], [132.5 / 12, 14.0845],
                                    [144.5 / 12, 14.49415], [156.5 / 12, 14.95335], [168.5 / 12, 15.44235], [180.5 / 12, 15.93785], [192.5 / 12, 16.41277], [204.5 / 12, 16.83603], [216.5 / 12, 17.1726], [228.5 / 12, 17.38385], [240.5 / 12, 17.42827]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "5th", data: [
                                    [24 / 12, 14.39787], [36.5 / 12, 14.00209], [48.5 / 12, 13.71472], [60.5 / 12, 13.52091], [72.5 / 12, 13.42587], [84.5 / 12, 13.43276], [96.5 / 12, 13.5405], [108.5 / 12, 13.74413], [120.5 / 12, 14.03535], [132.5 / 12, 14.4029],
                                    [144.5 / 12, 14.83262], [156.5 / 12, 15.30749], [168.5 / 12, 15.80753], [180.5 / 12, 16.30974], [192.5 / 12, 16.78787], [204.5 / 12, 17.21234], [216.5 / 12, 17.55015], [228.5 / 12, 17.76515], [240.5 / 12, 17.81856]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [24 / 12, 14.80134], [36.5 / 12, 14.32806], [48.5 / 12, 14.00895], [60.5 / 12, 13.81726], [72.5 / 12, 13.74694], [84.5 / 12, 13.7919], [96.5 / 12, 13.94445], [108.5 / 12, 14.19478], [120.5 / 12, 14.531], [132.5 / 12, 14.93913],
                                    [144.5 / 12, 15.40311], [156.5 / 12, 15.90476], [168.5 / 12, 16.42378], [180.5 / 12, 16.93767], [192.5 / 12, 17.42171], [204.5 / 12, 17.84878], [216.5 / 12, 18.18937], [228.5 / 12, 18.41159], [240.5 / 12, 18.48136]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "25th", data: [
                                    [24 / 12, 15.52808], [36.5 / 12, 14.9295], [48.5 / 12, 14.56345], [60.5 / 12, 14.38345], [72.5 / 12, 14.36552], [84.5 / 12, 14.48765], [96.5 / 12, 14.73005], [108.5 / 12, 15.07378], [120.5 / 12, 15.49992], [132.5 / 12, 15.98919],
                                    [144.5 / 12, 16.52179], [156.5 / 12, 17.07738], [168.5 / 12, 17.63509], [180.5 / 12, 18.1736], [192.5 / 12, 18.67121], [204.5 / 12, 19.10585], [216.5 / 12, 19.45491], [228.5 / 12, 19.695], [240.5 / 12, 19.80162]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [24 / 12, 16.4234], [36.5 / 12, 15.69924], [48.5 / 12, 15.29855], [60.5 / 12, 15.15188], [72.5 / 12, 15.2169], [84.5 / 12, 15.45357], [96.5 / 12, 15.827], [108.5 / 12, 16.30609], [120.5 / 12, 16.86231], [132.5 / 12, 17.46907],
                                    [144.5 / 12, 18.10149], [156.5 / 12, 18.73643], [168.5 / 12, 19.35257], [180.5 / 12, 19.93057], [192.5 / 12, 20.45326], [204.5 / 12, 20.90576], [216.5 / 12, 21.27532], [228.5 / 12, 21.55082], [240.5 / 12, 21.72191]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "75th", data: [
                                    [24 / 12, 17.42746], [36.5 / 12, 16.60687], [48.5 / 12, 16.20988], [60.5 / 12, 16.13843], [72.5 / 12, 16.33273], [84.5 / 12, 16.73462], [96.5 / 12, 17.29206], [108.5 / 12, 17.95912], [120.5 / 12, 18.6952], [132.5 / 12, 19.46462],
                                    [144.5 / 12, 20.23648], [156.5 / 12, 20.98472], [168.5 / 12, 21.68819], [180.5 / 12, 22.3309], [192.5 / 12, 22.90219], [204.5 / 12, 23.39696], [216.5 / 12, 23.81564], [228.5 / 12, 24.16378], [240.5 / 12, 24.45101]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "85th", data: [
                                    [24 / 12, 18.01821], [36.5 / 12, 17.16634], [48.5 / 12, 16.80058], [60.5 / 12, 16.80197], [72.5 / 12, 17.09974], [84.5 / 12, 17.62557], [96.5 / 12, 18.31718], [108.5 / 12, 19.11937], [120.5 / 12, 19.984], [132.5 / 12, 20.86984],
                                    [144.5 / 12, 21.74263], [156.5 / 12, 22.57506], [168.5 / 12, 23.34689], [180.5 / 12, 24.04503], [192.5 / 12, 24.66372], [204.5 / 12, 25.20482], [216.5 / 12, 25.67786], [228.5 / 12, 26.09993], [240.5 / 12, 26.49502]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [24 / 12, 18.44139], [36.5 / 12, 17.58019], [48.5 / 12, 17.25417], [60.5 / 12, 17.32657], [72.5 / 12, 17.71678], [84.5 / 12, 18.34873], [96.5 / 12, 19.15262], [108.5 / 12, 20.06647], [120.5 / 12, 21.03669], [132.5 / 12, 22.01829],
                                    [144.5 / 12, 22.97493], [156.5 / 12, 23.87895], [168.5 / 12, 24.71141], [180.5 / 12, 25.46204], [192.5 / 12, 26.12945], [204.5 / 12, 26.72125], [216.5 / 12, 27.25433], [228.5 / 12, 27.75502], [240.5 / 12, 28.25888]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "95th", data: [
                                    [24 / 12, 19.10624], [36.5 / 12, 18.25475], [48.5 / 12, 18.02851], [60.5 / 12, 18.25738], [72.5 / 12, 18.83778], [84.5 / 12, 19.67794], [96.5 / 12, 20.69525], [108.5 / 12, 21.81725], [120.5 / 12, 22.98258], [132.5 / 12, 24.14141],
                                    [144.5 / 12, 25.25564], [156.5 / 12, 26.2988], [168.5 / 12, 27.25597], [180.5 / 12, 28.12369], [192.5 / 12, 28.90981], [204.5 / 12, 29.6335], [216.5 / 12, 30.32554], [228.5 / 12, 31.0288], [240.5 / 12, 31.79903]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "97th", data: [
                                    [24 / 12, 19.56411], [36.5 / 12, 18.73838], [48.5 / 12, 18.61441], [60.5 / 12, 18.99615], [72.5 / 12, 19.75462], [84.5 / 12, 20.78075], [96.5 / 12, 21.98126], [108.5 / 12, 23.27714], [120.5 / 12, 24.60333], [132.5 / 12, 25.90868],
                                    [144.5 / 12, 27.15596], [156.5 / 12, 28.32185], [168.5 / 12, 29.39686], [180.5 / 12, 30.3852], [192.5 / 12, 31.30462], [204.5 / 12, 32.18603], [216.5 / 12, 33.07324], [228.5 / 12, 34.023], [240.5 / 12, 35.10556]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#cdc_bmi_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#c410d1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 20, min: 2, max: 21, axisLabel: 'Age (yr)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 24, min: 13, max: 36, axisLabel: 'BMI (KG / m2)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                cdcBoysHeight20();
                cdcGirlsHeight20();
                cdcBoysWeight20();
                cdcGirlsWeight20();
                cdcBoysBMI20();
                cdcGirlsBMI20();

                function whoBoysWH0() {
                    let item_tag_id = $("#who_boy_wh_0");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "2nd", data: [
                                    [45, 2.043085], [50, 2.80066], [55, 3.848024], [60, 5.09411], [65, 6.192965], [70, 7.177438], [75, 8.088095], [80, 8.889597], [85, 9.809266], [90, 10.87879], [95, 11.87963], [100, 12.92938], [105, 14.10877], [110, 15.41415]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [45, 2.175173], [50, 2.976081], [55, 4.081121], [60, 5.393876], [65, 6.55229], [70, 7.594181], [75, 8.561412], [80, 9.410618], [85, 10.37556], [90, 11.49627], [95, 12.55442], [100, 13.67733], [105, 14.94985], [110, 16.36525]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [45, 2.441], [50, 3.3278], [55, 4.5467], [60, 5.9907], [65, 7.2666], [70, 8.4227], [75, 9.5032], [80, 10.4475], [85, 11.5007], [90, 12.7209], [95, 13.8928], [100, 15.1637], [105, 16.6268], [110, 18.2689]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [45, 2.752713], [50, 3.738145], [55, 5.08708], [60, 6.68041], [65, 8.090377], [70, 9.378287], [75, 10.59067], [80, 11.64505], [85, 12.79732], [90, 14.12875], [95, 15.43158], [100, 16.87711], [105, 18.56848], [110, 20.48466]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "98th", data: [
                                    [45, 2.951324], [50, 3.998505], [55, 5.428484], [60, 7.114604], [65, 8.608089], [70, 9.978888], [75, 11.27481], [80, 12.39858], [85, 13.61171], [90, 15.01124], [95, 16.39622], [100, 17.95354], [105, 19.79277], [110, 21.88782]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#who_length_weight_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#107ad1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 14, min: 45, max: 110, axisLabel: 'Length (CM)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 21, min: 2, max: 22, axisLabel: 'Weight (KG)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function whoBoysHead0() {
                    let item_tag_id = $("#who_boy_head_0");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "2nd", data: [
                                    [0, 31.92128], [2, 36.78314], [4, 39.24371], [6, 40.88935], [8, 42.03988], [10, 42.8715], [12, 43.49653], [14, 43.98406], [16, 44.38101], [18, 44.71832], [20, 45.01543], [22, 45.28376], [24, 45.52915]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [0, 32.83389], [2, 37.62565], [4, 40.10153], [6, 41.76631], [8, 42.93439], [10, 43.78163], [12, 44.41958], [14, 44.91816], [16, 45.32497], [18, 45.67126], [20, 45.97688], [22, 46.2535], [24, 46.50708]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [0, 34.4618], [2, 39.1285], [4, 41.6317], [6, 43.3306], [8, 44.53], [10, 45.4051], [12, 46.0661], [14, 46.5844], [16, 47.0088], [18, 47.3711], [20, 47.6919], [22, 47.9833], [24, 48.2515]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [0, 36.08971], [2, 40.63135], [4, 43.16187], [6, 44.89489], [8, 46.12561], [10, 47.02857], [12, 47.71262], [14, 48.25064], [16, 48.69263], [18, 49.07094], [20, 49.40692], [22, 49.7131], [24, 49.99592]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "98th", data: [
                                    [0, 37.0023239], [2, 41.4738623], [4, 44.0196943], [6, 45.771846], [8, 47.0201176], [10, 47.9387046], [12, 48.6356671], [14, 49.1847412], [16, 49.6365919], [18, 50.0238816], [20, 50.3683694], [22, 50.6828405], [24, 50.9738496]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#who_age_head_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#107ad1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 12, min: 0, max: 24, axisLabel: 'Age (Mo)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 10, min: 32, max: 52, axisLabel: 'Head Circumference (CM)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function whoBoysLengthAge0() {
                    let item_tag_id = $("#who_boy_length_age_0");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "2nd", data: [
                                    [0, 46.09799], [2, 54.42396], [4, 59.72447], [6, 63.34303], [8, 66.18835], [10, 68.71138], [12, 70.99632], [14, 73.09511], [16, 75.04248], [18, 76.86417], [20, 78.5717], [22, 80.17925], [24, 81.70586]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [0, 47.45809], [2, 55.8612], [4, 61.21939], [6, 64.88071], [8, 67.77291], [10, 70.35297], [12, 72.70353], [14, 74.87492], [16, 76.89925], [18, 78.80202], [20, 80.59338], [22, 82.28734], [24, 83.9008]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [0, 49.8842], [2, 58.4249], [4, 63.886], [6, 67.6236], [8, 70.5994], [10, 73.2812], [12, 75.7488], [14, 78.0497], [16, 80.2113], [18, 82.2587], [20, 84.1996], [22, 86.0477], [24, 87.8161]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [0, 52.31031], [2, 60.9886], [4, 66.55261], [6, 70.36649], [8, 73.42589], [10, 76.20943], [12, 78.79407], [14, 81.22448], [16, 83.52335], [18, 85.71538], [20, 87.80582], [22, 89.80806], [24, 91.7314]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "98th", data: [
                                    [0, 53.67041], [2, 62.42584], [4, 68.04753], [6, 71.90417], [8, 75.01045], [10, 77.85102], [12, 80.50128], [14, 83.0043], [16, 85.38012], [18, 87.65323], [20, 89.8275], [22, 91.91615], [24, 93.92634]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#who_age_length_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#107ad1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 12, min: 0, max: 24, axisLabel: 'Age (Mo)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 25, min: 46, max: 94, axisLabel: 'Length (CM)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function whoBoysWeightAge0() {
                    let item_tag_id = $("#who_boy_weight_age_0");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "2nd", data: [
                                    [0, 2.459312], [2, 4.31889], [4, 5.561377], [6, 6.352967], [8, 6.913126], [10, 7.356558], [12, 7.742219], [14, 8.095984], [16, 8.430734], [18, 8.752902], [20, 9.065209], [22, 9.371554], [24, 9.672527]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [0, 2.757621], [2, 4.738362], [4, 6.046988], [6, 6.885864], [8, 7.486158], [10, 7.964565], [12, 8.382077], [14, 8.76637], [16, 9.13126], [18, 9.483736], [20, 9.826848], [22, 10.16471], [24, 10.49784]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [0, 3.3464], [2, 5.5675], [4, 7.0023], [6, 7.934], [8, 8.6151], [10, 9.1649], [12, 9.6479], [14, 10.0953], [16, 10.5228], [18, 10.9385], [20, 11.3462], [22, 11.7504], [24, 12.1515]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [0, 4.011499], [2, 6.509323], [4, 8.082087], [6, 9.119041], [8, 9.894622], [10, 10.5293], [12, 11.09087], [14, 11.61449], [16, 12.11808], [18, 12.61101], [20, 13.09811], [22, 13.58426], [24, 14.06979]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "98th", data: [
                                    [0, 4.419354], [2, 7.090758], [4, 8.746662], [6, 9.848832], [8, 10.68428], [10, 11.37341], [12, 11.98574], [14, 12.55884], [16, 13.11206], [18, 13.65558], [20, 14.19492], [22, 14.7352], [24, 15.27674]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#who_age_weight_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#107ad1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 12, min: 0, max: 24, axisLabel: 'Age (Mo)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 15, min: 2, max: 16, axisLabel: 'Weight (CM)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function whoGirlsWH0() {
                    let item_tag_id = $("#who_girl_wh_0");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "2nd", data: [
                                    [45, 2.066469], [50, 2.812752], [55, 3.815089], [60, 4.923229], [65, 5.936714], [70, 6.850199], [75, 7.68668], [80, 8.486836], [85, 9.445392], [90, 10.49824], [95, 11.5316], [100, 12.60982], [105, 13.84672], [110, 15.28873]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [45, 2.197295], [50, 2.991576], [55, 4.058733], [60, 5.238517], [65, 6.316217], [70, 7.285707], [75, 8.172055], [80, 9.018962], [85, 10.0349], [90, 11.15403], [95, 12.25645], [100, 13.41159], [105, 14.74134], [110, 16.29552]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [45, 2.4607], [50, 3.3518], [55, 4.5498], [60, 5.8742], [65, 7.0812], [70, 8.163], [75, 9.149], [80, 10.0891], [85, 11.2198], [90, 12.4723], [95, 13.7146], [100, 15.0267], [105, 16.547], [110, 18.3324]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [45, 2.769874], [50, 3.774909], [55, 5.127025], [60, 6.621759], [65, 7.980543], [70, 9.193444], [75, 10.29521], [80, 11.3432], [85, 12.60735], [90, 14.01625], [95, 15.42411], [100, 16.9238], [105, 18.67358], [110, 20.73907]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "98th", data: [
                                    [45, 2.967084], [50, 4.044951], [55, 5.495657], [60, 7.099354], [65, 8.554964], [70, 9.851105], [75, 11.02607], [80, 12.14209], [85, 13.4907], [90, 14.99928], [95, 16.51348], [100, 18.13461], [105, 20.03387], [110, 22.28267]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#who_length_weight_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#c410d1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 14, min: 45, max: 110, axisLabel: 'Length (CM)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 22, min: 2, max: 23, axisLabel: 'Weight (KG)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function whoGirlsHead0() {
                    let item_tag_id = $("#who_girl_head_0");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "2nd", data: [
                                    [0, 31.5099], [2, 35.82845], [4, 38.05021], [6, 39.5941], [8, 40.71043], [10, 41.53906], [12, 42.17847], [14, 42.69001], [16, 43.11402], [18, 43.47988], [20, 43.80672], [22, 44.10877], [24, 44.39184]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [0, 32.36083], [2, 36.69908], [4, 38.95958], [6, 40.53002], [8, 41.66477], [10, 42.50639], [12, 43.15485], [14, 43.67302], [16, 44.10224], [18, 44.47224], [20, 44.80299], [22, 45.10832], [24, 45.39421]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [0, 33.8787], [2, 38.2521], [4, 40.5817], [6, 42.1995], [8, 43.3671], [10, 44.2319], [12, 44.8965], [14, 45.4265], [16, 45.865], [18, 46.2424], [20, 46.5801], [22, 46.8913], [24, 47.1822]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [0, 35.39657], [2, 39.80512], [4, 42.20382], [6, 43.86898], [8, 45.06943], [10, 45.95741], [12, 46.63815], [14, 47.17998], [16, 47.62776], [18, 48.01256], [20, 48.35721], [22, 48.67428], [24, 48.97019]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "98th", data: [
                                    [0, 36.2474987], [2, 40.6757531], [4, 43.1131864], [6, 44.8048971], [8, 46.0237685], [10, 46.9247381], [12, 47.6145341], [14, 48.1629924], [16, 48.6159827], [18, 49.004921], [20, 49.3534792], [22, 49.6738297], [24, 49.9725553]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#who_age_head_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#c410d1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 12, min: 0, max: 24, axisLabel: 'Age (Mo)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 10, min: 31, max: 51, axisLabel: 'Head Circumference (CM)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function whoGirlsLengthAge0() {
                    let item_tag_id = $("#who_girl_length_age_0");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "2nd", data: [
                                    [0, 45.4223043], [2, 52.9949775], [4, 57.7609922], [6, 61.1982833], [8, 64.0198138], [10, 66.5466965], [12, 68.8650363], [14, 71.0135941], [16, 73.016649], [18, 74.9001595], [20, 76.6778157], [22, 78.363609], [24, 79.9618054]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [0, 46.76056], [2, 54.45785], [4, 59.31604], [6, 62.82658], [8, 65.71894], [10, 68.31951], [12, 70.71503], [14, 72.94195], [16, 75.0243], [18, 76.98644], [20, 78.84242], [22, 80.60531], [24, 82.28006]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [0, 49.1477], [2, 57.0673], [4, 62.0899], [6, 65.7311], [8, 68.7498], [10, 71.4818], [12, 74.015], [14, 76.3817], [16, 78.6055], [18, 80.7079], [20, 82.7036], [22, 84.604], [24, 86.4153]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [0, 51.53484], [2, 59.67675], [4, 64.86376], [6, 68.63562], [8, 71.78066], [10, 74.64409], [12, 77.31497], [14, 79.82145], [16, 82.1867], [18, 84.42936], [20, 86.56478], [22, 88.60269], [24, 90.55054]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "98th", data: [
                                    [0, 52.8730957], [2, 61.1396225], [4, 66.4188078], [6, 70.2639167], [8, 73.4797862], [10, 76.4169035], [12, 79.1649637], [14, 81.7498059], [16, 84.1943511], [18, 86.5156405], [20, 88.7293843], [22, 90.844391], [24, 92.8687946]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#who_age_length_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#c410d1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 12, min: 0, max: 24, axisLabel: 'Age (Mo)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 25, min: 45, max: 93, axisLabel: 'Length (CM)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                function whoGirlsWeightAge0() {
                    let item_tag_id = $("#who_girl_weight_age_0");
                    if (item_tag_id.size() !== 1) {
                        return;
                    }
                    var plot = $.plot(item_tag_id, [
                            {
                                label: "2nd", data: [
                                    [0, 2.394672], [2, 3.941053], [4, 5.013368], [6, 5.729383], [8, 6.253445], [10, 6.673828], [12, 7.042612], [14, 7.389684], [16, 7.727588], [18, 8.060311], [20, 8.387882], [22, 8.712397], [24, 9.035869]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "10th", data: [
                                    [0, 2.677725], [2, 4.335355], [4, 5.480078], [6, 6.246243], [8, 6.810403], [10, 7.265345], [12, 7.665043], [14, 8.040838], [16, 8.406286], [18, 8.766325], [20, 9.121584], [22, 9.474611], [24, 9.827655]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "Mean", data: [
                                    [0, 3.2322], [2, 5.1282], [4, 6.4237], [6, 7.297], [8, 7.9487], [10, 8.48], [12, 8.9481], [14, 9.387], [16, 9.8124], [18, 10.2315], [20, 10.6464], [22, 11.0608], [24, 11.4775]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "90th", data: [
                                    [0, 3.852667], [2, 6.049862], [4, 7.530756], [6, 8.540297], [8, 9.306424], [10, 9.939115], [12, 10.49835], [14, 11.02071], [16, 11.52454], [18, 12.02024], [20, 12.51209], [22, 13.00554], [24, 13.50419]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: "98th", data: [
                                    [0, 4.23043022], [2, 6.62967897], [4, 8.23331075], [6, 9.33549062], [8, 10.1810939], [10, 10.8851054], [12, 11.5086985], [14, 12.0897773], [16, 12.6483665], [18, 13.1972107], [20, 13.7422028], [22, 14.2901756], [24, 14.8452857]
                                ], lines: {lineWidth: 1}, shadowSize: 0
                            },
                            {
                                label: 'patient', data: JSON.parse($('#who_age_weight_data').html()), color: "#b03030",
                                points: {show: true, fill: true, radius: 2, lineWidth: 1}
                            }
                        ],
                        {
                            series: {
                                lines: {show: true,},
                                points: {show: false, fill: true, radius: 2, lineWidth: 1}
                            },
                            crosshair: {
                                mode: "x"
                            },
                            axisLabels: {
                                show: true
                            },
                            colors: ["#c410d1"],
                            xaxis: {
                                tickColor: "#eee", ticks: 12, min: 0, max: 24, axisLabel: 'Age (Mo)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            yaxis: {
                                tickColor: "#eee", ticks: 14, min: 2, max: 15, axisLabel: 'Weight (CM)', tickFormatter: function (v) {
                                    return v;
                                }
                            },
                            grid: {borderColor: "#eee", borderWidth: 1, hoverable: true, clickable: true, autoHighlight: true,}
                        });

                    var previousPoint = null;
                    drawTooltipsChart(item_tag_id, previousPoint, plot);
                }

                whoBoysWH0();
                whoBoysHead0();
                whoBoysLengthAge0();
                whoBoysWeightAge0();
                whoGirlsWH0();
                whoGirlsHead0();
                whoGirlsLengthAge0();
                whoGirlsWeightAge0();

            }
        };
    }();

    ChartsFlotCharts.initCharts();


});