<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */
require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $patientid;

    // it will run in everytime with
    // default requried
    public function __construct() {
	require_once("../public/aw_config.php");
	require_once("imp/_autho.php"); //general functions
	$this->smarty = $smarty;
	$this->hosturl = $hosturl;

	//here name of controll to known
	$this->controllname = 'ultrasoundgyna';
	$this->shcontrollname = 'ultrasoundgyna';
	$this->smarty->assign('controllname', $this->controllname);
	$this->smarty->assign('shcontrollname', $this->shcontrollname);

	//breadcrumbs
	require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
	$acty = filter_input(INPUT_GET, 'ac');
	$bc = new breadcrumbs($hosturl, '', '', $acty);
	$bc->crumbs();
	$breadcrumbs = $bc->breadcrumbs;
	$smarty->assign('breadcrumbs', $breadcrumbs);

	# here show the active page in menu
	// array called active[] with level of active element
	$active[0] = 'Ultrasound Gyna'; //controller name or tab name
	$this->active = $active;


	//here will call all php pages
	require_once("_header.php");
	require_once("_patientdata.php");
	require_once("_sidebar.php");
	require_once("_leftsidebar.php");
	require_once("_footer.php");
	$this->patientid = patientdata::patientid();
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
	//here will load the menu show

	$today = date("Y-m-d");
	$this->smarty->assign('today', $today);

	$patientid = filter_input(INPUT_GET, "patientid");
	if (empty($this->patientid)) {
	    header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
	    exit();
	}

	$allultra = R::findAll('ultrasoundgyna', 'patientid = ? and del = 0 and done = 1', [$patientid]);
	foreach ($allultra as $data) {
	    $patientData = R::load("patients", $data->patientid);
	    $data->pname = $patientData->wifename;
	}

	//$patientid = 1;
	$this->smarty->assign('allultra', $allultra);
	$this->smarty->assign('patientid', $this->patientid);

	$patientData = R::load("patients", $patientid);


	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	patientdata::patientdatashow($this->smarty, $this->hosturl);
	$this->smarty->display('ultrasoundgyna/show.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function show() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$patientId = filter_input(INPUT_GET, "patientid");

	$patientData = R::load("patients", $patientId);
	$patientData->dateofbirth = date("Y/m/d", strtotime($patientData->dateofbirth));
	$this->smarty->assign('patientData', $patientData);

	$id = filter_input(INPUT_GET, "id");

	$allSono = R::getAll('select * from awusers where positionid = 4');

	$ultrasoundgynaData = R::load('ultrasoundgyna', $id);

	$ultrasoundgynaData->edate = date('Y/m/d', strtotime($ultrasoundgynaData->edate));

	$this->smarty->assign('allSname', $allSono);
	$this->smarty->assign('ultrasoundgynaData', $ultrasoundgynaData);

	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	patientdata::patientdatashow($this->smarty, $this->hosturl);
	$this->smarty->display('ultrasoundgyna/add.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$patientId = filter_input(INPUT_GET, "patientid");

	$patientData = R::load("patients", $patientId);
	$patientData->dateofbirth = date("Y/m/d", strtotime($patientData->dateofbirth));
	$this->smarty->assign('patientData', $patientData);

	$allSono = R::getAll('select * from awusers where positionid = 4');

	$ultrasoundgynaData = R::findOne('ultrasoundgyna', 'patientid = ? and del = 0 order by id desc limit 1', [$patientId]);

	if (empty($ultrasoundgynaData) || $ultrasoundgynaData->done == 1) {
	    $today = date("Y-m-d");

	    $ultrasoundgyna = R::dispense('ultrasoundgyna');

	    $ultrasoundgyna->patientid = $patientId;
	    $ultrasoundgyna->del = 0;
	    $ultrasoundgyna->done = 0;
	    $ultrasoundgyna->edate = $today;
	    $ultrasoundgyna->etype = 0;
	    $ultrasoundgyna->sid = 0;
	    $ultrasoundgyna->tcondition = 0;
	    $ultrasoundgyna->position = 0;
	    $ultrasoundgyna->tz = 0;
	    $ultrasoundgyna->myo = 0;
	    $ultrasoundgyna->myowall = 0;
	    $ultrasoundgyna->douglas = 0;
	    $ultrasoundgyna->conclusion = 0;

	    $id = R::store($ultrasoundgyna);

	    $ultrasoundgynaData = R::load('ultrasoundgyna', $id);
	} else {
	    $ultrasoundgynaData = R::findOne('ultrasoundgyna', 'patientid = ? and del =0 order by id desc limit 1', [$patientId]);
	}

	$ultrasoundgynaData->edate = date('Y/m/d', strtotime($ultrasoundgynaData->edate));

	$this->smarty->assign('allSname', $allSono);
	$this->smarty->assign('ultrasoundgynaData', $ultrasoundgynaData);

	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	patientdata::patientdatashow($this->smarty, $this->hosturl);
	$this->smarty->display('ultrasoundgyna/add.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function update() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_POST, "id");
	$value = filter_input(INPUT_POST, "value");
	$tableName = filter_input(INPUT_POST, "tableName");
	$colName = filter_input(INPUT_POST, "colName");
	$patientId = filter_input(INPUT_POST, "patientId");
	$dated = filter_input(INPUT_POST, "dated");

	if ($dated == 1) {
	    $value = date("Y-m-d", strtotime($value));
	}

	$mydata = R::findone($tableName, 'id = ? and patientid = ?', [$id, $patientId]);
	$mydata->$colName = $value;
	R::store($mydata);
    }

    public function delRow() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_GET, "id");
	$patientid = filter_input(INPUT_GET, "patientid");

	$myData = R::load('ultrasoundgyna', $id);
	$myData->del = 1;
	$myid = R::store($myData);

	header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?patientid=' . $patientid);
    }

    public function showprint() {

	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$patientId = filter_input(INPUT_POST, "patientid");

	$patientData = R::load("patients", $patientId);
	$patientData->dateofbirth = date("Y/m/d", strtotime($patientData->dateofbirth));
	$this->smarty->assign('patientData', $patientData);

	$id = filter_input(INPUT_POST, "id");

	$allSono = R::getAll('select * from awusers where positionid = 4');

	$ultrasoundgynaData = R::load('ultrasoundgyna', $id);

	$ultrasoundgynaData->edate = date('Y/m/d', strtotime($ultrasoundgynaData->edate));

	$mydata = R::load('ultrasoundgyna', $ultrasoundgynaData->id);

	$mydata->done = 1;
	R::store($mydata);

	$this->smarty->assign('allSname', $allSono);
	$this->smarty->assign('ultrasoundgynaData', $ultrasoundgynaData);
	$this->smarty->display('ultrasoundgyna/print.html');
    }

    public function onesetup() {

	//check login
	autho::checkautho($this->hosturl);

	try {
	    //delete all but with only default
	    #1 clean roles only managment
	    #2 clean menu only default
	    #3 clean controls only default
	    #4 users clean users
	    #delete all menus
	    $menus = R::findAll('awmenu', 'id > 15');
	    #delete from awrolemenu
	    foreach ($menus as $one) {
		//get propes
		$rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
		R::trashAll($rolemenu);
	    }
	    R::trashAll($menus);
	    #delete controles
	    $controlls = R::findAll('awcontroll', 'id > 4 and id < 18');
	    foreach ($controlls as $one) {
		//get propes
		$inprop = R::findAll('awcontrollprop', 'awcontroll_id = ?', [$one->id]);
		#delete from awrolecontroleprop
		foreach ($inprop as $one) {
		    //get propes
		    $roleprop = R::findAll('awrolecontrollprop', 'controllprop_id = ?', [$one->id]);
		    R::trashAll($roleprop);
		}
		R::trashAll($inprop);
	    }
	    R::trashAll($controlls);
	    #delete othre roles
	    $roles = R::findAll('awrole', 'id > 1');
	    R::trashAll($roles);
	    #delete other users
	    //$users = R::findAll('awusers', 'user_id > 1');
	    //R::exec('Delete from awusers where user_id > 1');
	    //R::trashAll($users);
	    ############################
	    //new one
	    $menusx = R::findAll('awmenu', ' id = 4 or id = 5 or id = 7 or id = 8 or id = 10 or id = 11 or id = 13 or id = 14 or id = 15 ');
	    #delete from awrolemenu
	    foreach ($menusx as $one) {
		//get propes
		$rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
		R::trashAll($rolemenu);
	    }
	    R::trashAll($menusx);

	    print_r('trash all , install is good');
	} catch (Exception $ex) {
	    print_r('something go wrong  , try again');
	}
    }

    // at the end of class call
    public function __destruct() {
	//close connection
	R::close();
    }

}
