<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
	require_once("../public/aw_config.php");
	require_once("imp/_autho.php"); //general functions
	$this->smarty = $smarty;
	$this->hosturl = $hosturl;

	//here name of controll to known
	$this->controllname = 'expected';
	$this->shcontrollname = 'Home';
	$this->smarty->assign('controllname', $this->controllname);
	$this->smarty->assign('shcontrollname', $this->shcontrollname);

	//breadcrumbs
	require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
	$acty = filter_input(INPUT_GET, 'ac');
	$bc = new breadcrumbs($hosturl, '', '', $acty);
	$bc->crumbs();
	$breadcrumbs = $bc->breadcrumbs;
	$smarty->assign('breadcrumbs', $breadcrumbs);

	# here show the active page in menu
	// array called active[] with level of active element
	$active[0] = 'expected'; //controller name or tab name
	$this->active = $active;


	//here will call all php pages
	require_once("_header.php");
	require_once("_sidebar.php");
	require_once("_leftsidebar.php");
	require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
	//here will load the menu show

	$today = date("Y/m/d");
	$this->smarty->assign('today', date('Y/m/d', strtotime($today)));

	$programSetting = R::findOne('programesetting');
	$this->smarty->assign("programSetting", $programSetting);

	$allDetections = R::findAll('detections', 'del = 0');
	$this->smarty->assign('allDetections', $allDetections);


	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	$this->smarty->display('reports/full/full.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function search() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	//R::debug(TRUE);
	$fromdate = filter_input(INPUT_POST, 'fromdate');
	$todate = filter_input(INPUT_POST, 'todate');
	$fullDept = filter_input(INPUT_POST, 'fullDept');

	if ($fromdate == '') {
	    $fromdate = date('Y/m/d');
	}

	if ($todate == '') {
	    $todate = date('Y/m/d');
	}

	$fromdate = date("Y/m/d", strtotime($fromdate));
	$todate = date("Y/m/d", strtotime($todate));


	## get all patients made visits in this time
	if ($fullDept == '') {
	    $patients = R::getAll('SELECT distinct patientid   FROM  visits  join patients on patients.id = visits.patientid
                                    where patients.deleted = 0 and  visitdate  between ? and ? ', [$fromdate, $todate]);
	} else {
	    $patients = R::getAll('SELECT distinct patientid   FROM  visits  join patients on patients.id = visits.patientid
                                    where patients.deleted = 0 and  visits.detectionid = ? and   visitdate  between ? and ? ', [$fullDept, $fromdate, $todate]);
	}


	$i = 0;
	foreach ($patients as $data) {
	    $pat = R::load('patients', $data['patientid']);
	    ## no of visits / patient in this period
	    if ($fullDept == '') {
		$visitCount = R::getRow('SELECT count(id)  FROM `visits`  WHERE patientid = ? and  `visitdate` between ? and ? ', [$patients[$i]['patientid'], $fromdate, $todate]);
	    } else {
		$visitCount = R::getRow('SELECT count(id)  FROM `visits`  WHERE patientid = ? and  detectionid = ? and  `visitdate` between ? and ? ', [$patients[$i]['patientid'], $fullDept, $fromdate, $todate]);
	    }


	    $patients[$i]['wifeName'] = $pat->wifename;
	    $patients[$i]['statusno'] = $pat->statusno;
	    $patients[$i]['visitCount'] = $visitCount['count(id)'];

	    $patients[$i]['patienthistory'] = $this->patienthistory($fromdate, $todate, $patients[$i]['patientid']);
	    $patients[$i]['examination'] = $this->examination($fromdate, $todate, $patients[$i]['patientid']);
	    $patients[$i]['investigation'] = $this->investigation($fromdate, $todate, $patients[$i]['patientid']);
	    $patients[$i]['antenatal'] = $this->antenatal($fromdate, $todate, $patients[$i]['patientid']);
	    $patients[$i]['gyna'] = $this->gyna($fromdate, $todate, $patients[$i]['patientid']);
	    $patients[$i]['usgyna'] = $this->usgyna($fromdate, $todate, $patients[$i]['patientid']);
	    $patients[$i]['usant'] = $this->usant($fromdate, $todate, $patients[$i]['patientid']);
	    $patients[$i]['sonar'] = $this->sonar($fromdate, $todate, $patients[$i]['patientid']);
	    $patients[$i]['operation'] = $this->operation($fromdate, $todate, $patients[$i]['patientid']);
	    $i++;
	}

	$this->smarty->assign('allData', $patients);
	$this->smarty->display('reports/full/fullsearch.html');
    }

    public function showprint() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	//R::debug(TRUE);
	$fromdate = filter_input(INPUT_POST, 'fromdate');
	$todate = filter_input(INPUT_POST, 'todate');

	$fromdate = date("Y/m/d", strtotime($fromdate));
	$todate = date("Y/m/d", strtotime($todate));

	$allData = R::findAll('mainantenental', 'eed >= ? and eed <= ?', [$fromdate, $todate]);
	foreach ($allData as $data) {
	    $data->info = R::load('patients', $data->patientid);
	    $data->eed = date('Y/m/d', strtotime($data->eed));
	}
	// print_r($allData);
	$this->smarty->assign('allData', $allData);
	$this->smarty->display('reports/expectedprint.html');
    }

    private function patienthistory($fromdate, $todate, $patientid) {
	if (count(R::findAll('phmenstrual', 'patientid = ? and del = 0 and sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('phcontraception', 'patientid = ? and del = 0 and sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('phobstetric', 'patientid = ? and del = 0 and sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('phpastmedical', 'patientid = ? and del = 0 and sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('phpastsurgical', 'patientid = ? and del = 0 and sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('phpastgynecological', 'patientid = ? and del = 0 and sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('phpastart', 'patientid = ? and del = 0 and sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('phfamily', 'patientid = ? and del = 0 and sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} else {
	    return 0;
	}
    }

    private function examination($fromdate, $todate, $patientid) {
	if (count(R::findAll('examination', 'patientid = ? and del = 0 and sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} else {
	    return 0;
	}
    }

    private function investigation($fromdate, $todate, $patientid) {
	if (count(R::findAll('semen', 'patientid = ? and del = 0 and sdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('hsg', 'patientid = ? and del = 0 and sdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('ustv', 'patientid = ? and del = 0 and sdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('laparoscopy', 'patientid = ? and del = 0 and sdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('hysteroscopy', 'patientid = ? and del = 0 and sdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('mrict', 'patientid = ? and del = 0 and sdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('pathology', 'patientid = ? and del = 0 and sdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('hormon', 'patientid = ? and del = 0 and sdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} else {
	    return 0;
	}
    }

    private function antenatal($fromdate, $todate, $patientid) {
	if (count(R::findAll('antenalvisit', 'patientid = ? and conditions = 0 and antenaldate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('mainantenental', 'patientid = ? and   sysdate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('mainantenentaldrugs', 'patientid = ? and deleted = 0 and date between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('mainantenentalinvest', 'patientid = ? and deleted = 0 and date between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('mainantenentalus', 'patientid = ? and deleted = 0 and date between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} else {
	    return 0;
	}
    }

    private function gyna($fromdate, $todate, $patientid) {
	if (count(R::findAll('gyna', 'patientid = ? and conditions = 0 and gynadate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('gynadrugs', 'patientid = ? and deleted = 0 and date between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('gynainvestigation', 'patientid = ? and deleted = 0 and date between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('gynaus', 'patientid = ? and deleted = 0 and date between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::getAll('SELECT * FROM `gynausficils` join gynaus on gynaus.id = gynausficils.`gynausid` where gynaus.patientid = ?
                                   and gynausficils.sysdate between ? and ? '
				, [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} else {
	    return 0;
	}
    }

    private function usgyna($fromdate, $todate, $patientid) {
	if (count(R::findAll('ultrasoundgyna', 'patientid = ? and del = 0 and edate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} else {
	    return 0;
	}
    }

    private function usant($fromdate, $todate, $patientid) {
	if (count(R::findAll('ultrasoundobst', 'patientid = ? and del = 0 and edate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} elseif (count(R::findAll('ultrasound', 'patientid = ? and del = 0 and edate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} else {
	    return 0;
	}
    }

    private function sonar($fromdate, $todate, $patientid) {
	if (count(R::findAll('sonar', 'patientid = ? and tempdelete = 0 and sonardate between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} else {
	    return 0;
	}
    }

    private function operation($fromdate, $todate, $patientid) {
	if (count(R::findAll('operativedetails', 'patientid = ? and del = 0 and date between ? and ? ', [$patientid, $fromdate, $todate])) > 0) {
	    return 1;
	} else {
	    return 0;
	}
    }

    // at the end of class call
    public function __destruct() {
	//close connection
	R::close();
    }

}
