<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    
    public $time;
    public $today;
    
// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'addinvestigation';
        $this->shcontrollname = 'addinvestigation';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'addinvestigation'; //controller name or tab name
        $active[1] = 'addinvestigation'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'show';
                break;
            case 'show':$active[2] = 'show';
                break;
            default :$active[2] = 'show';
                break;
        }
        $this->active = $active;



//here will call all php pages
       require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
        
     //find loading time
        $this->time = microtime(true);   
        $this->today = date('Y-m-d');
    }

    public function index() {
        //check login
          autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
 
        #################################################################### Heba : ## get all investigation category ##############################################################################
        $allInv = R::findall('investcats','deleted = ? and displayorder != ?',[0,-1]);
        $this->smarty->assign('allInv',$allInv);
        ################################################################################################################################################################################
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('addinvestigation/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addnewcat() {
        //check login
          autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
 
        #################################################################### Heba : ## add investigation cat  #############################################################################
        $last = R::getAll('select max(displayorder) from investcats');
        $lastOrder = $last[0]['max(displayorder)'] ;
        $newOrder = $lastOrder + 1 ;
        $newcat =  R::dispense('investcats');
        $newcat->name = "" ;
        $newcat->displayorder = $newOrder ;
        try 
        {
            $id = R::store($newcat);
            echo $id;
        } 
        catch (Exception $e)
        {
             header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }      
        ################################################################################################################################################################################
    }
    
    public function addnewinv() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
 
        #################################################################### Heba : ## add investigation cat  #############################################################################
        $catId = filter_input(INPUT_POST, "catId");
        
        $newInv =  R::dispense('invests');
        $newInv->name = "" ;
        $newInv->investcatid = $catId ;
        try 
        {
            $id = R::store($newInv);
            echo $id;
        } 
        catch (Exception $e)
        {
             header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }      
        ################################################################################################################################################################################
    }
    
    public function update()
    {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");
        
        try {
            $obj = R::load($tablename,$id);
        
            $obj->$colname = $value;
            R::store($obj);
        
            //header('Location:' . $this->hosturl . '/controllers/' . $this->controllname.'.php?ac=index' );
        } catch (Exception $e) {
           header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
        
        
        
    }
    
    public function del()      ## delete row from investcat table 
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
       
        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");
        
        $ogj = R::load($tableName,$id);
        $ogj->deleted = 1;
        
        try 
        {
            R::store($ogj);
            echo 1;
        } catch (Exception $e) {
           echo 22;
        }        
        
    }
    
    public function getinvbycatid()      ## get all investigation in certain category
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
       
        $catId = filter_input(INPUT_POST, "catId");
        
        $invests = R::findall('invests','investcatid = ? and deleted = ?',[$catId , 0]);
        
        $this->smarty->assign('invests',$invests);
        $this->smarty->display('addinvestigation/invests.html');

    }
    
     public function addtofavorite()      ## get all investigation in certain category
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
       
        $invId = filter_input(INPUT_POST, "invId");
        $value = filter_input(INPUT_POST, "value");
        
        try {
            $inv = R::load('invests',$invId);
        
            $inv->favorite = $value;
            R::store($inv);
    
        } catch (Exception $e) {
           header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }

    }
    

// at the end of class call
    public function __destruct()
    {
        //echo "Time Elapsed: ".(microtime(true) - $this->time)."s";
//close connection
        R::close();
       
    }

}
