<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers
{

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'Ivfstatistics';
        $this->shcontrollname = 'Home';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'Ivfstatistics'; //controller name or tab name
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index()
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $allPatient = R::findAll('patients');
        $this->smarty->assign('allPatient', $allPatient);

        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        $allData = R::findAll('ivfsheet', 'lmpfresh = ? or lmpfrozen = ?', [$today, $today]);
        $this->smarty->assign('allData', $allData);
        foreach ($allData as $data) {
            $data->info = R::load('patients', $data->patientid);
            $data->antypet = R::load('antype', $data->antype);
            $data->anprotocolt = R::load('icsiprotocol', $data->anprotocol);
            // $data->allovst = R::findAll('ovst', 'ivfsheetid = ?', [$data->id]);
            $data->ovsthmgs = R::findone('ovst', 'ivfsheetid = ? order by id asc limit 1', [$data->id]);
            $data->ovste = R::findone('ovst', 'ivfsheetid = ? order by id DESC limit 1', [$data->id]);
            $data->countovst = R::count('ovst', 'ivfsheetid = ? order by id DESC limit 1', [$data->id]);
            $data->sseement = R::load('sseemen', $data->sseemen);
            $data->icsisement = R::load('icsisemen', $data->sseemmen);
            $data->counteprep = R::count('eprep', 'ivfsheetid = ?', [$data->id]);

            $data->eprepasc = R::findone('eprep', 'ivfsheetid = ? order by id asc limit 1', [$data->id]);
            $data->eprepdes = R::findone('eprep', 'ivfsheetid = ? order by id DESC limit 1', [$data->id]);
            $data->examinations = R::findone('examination', 'del = ? and patientid = ? order by id DESC limit 1', [0, $data->patientid]);
            $data->anprotocolt = R::load('icsiprotocol', $data->anprotocol);

        }

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('reports2/Ivfstatistics.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }
    public function Add() {

    
        $table = filter_input(INPUT_POST, 'table');
        $id = filter_input(INPUT_POST, 'id');
        $name = filter_input(INPUT_POST, 'name');
        $value = filter_input(INPUT_POST, 'value');

        try{
        $tableadd = R::exec("update $table set $name = '".$value."' where id = $id");
            //echo $tableadd;
        } catch (Exception $e) {
            //echo $e->getMessage();
        }
      
    }


    public function search()
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //R::debug(TRUE);
        $fromdate = filter_input(INPUT_POST, 'fromdate');
        $todate = filter_input(INPUT_POST, 'todate');
        $patientid = filter_input(INPUT_POST, 'patientid');

        $fromdate = date("Y/m/d", strtotime($fromdate));
        $todate = date("Y/m/d", strtotime($todate));
        if (!$patientid) {
           $allData = R::findAll('ivfsheet', 'lmpfresh >= ? and lmpfresh <= ? or lmpfrozen >= ? and lmpfrozen <= ?', [$fromdate, $todate, $fromdate, $todate]);
        }else{
            $allData = R::findAll('ivfsheet', 'patientid = ? and (lmpfresh >= ? and lmpfresh <= ? or lmpfrozen >= ? and lmpfrozen <= ?)', [$patientid, $fromdate, $todate, $fromdate, $todate]);

        }

  



       
        $this->smarty->assign('allData', $allData);
        foreach ($allData as $data) {
            $data->info = R::load('patients', $data->patientid);
            $data->antypet = R::load('antype', $data->antype);
            $data->anprotocolt = R::load('icsiprotocol', $data->anprotocol);
            // $data->allovst = R::findAll('ovst', 'ivfsheetid = ?', [$data->id]);
            $data->ovsthmgs = R::findone('ovst', 'ivfsheetid = ? order by id asc limit 1', [$data->id]);
            $data->ovste = R::findone('ovst', 'ivfsheetid = ? order by id DESC limit 1', [$data->id]);
            $data->countovst = R::count('ovst', 'ivfsheetid = ? order by id DESC limit 1', [$data->id]);
            $data->sseement = R::load('sseemen', $data->sseemen);
            $data->icsisement = R::load('icsisemen', $data->sseemmen);
            $data->counteprep = R::count('eprep', 'ivfsheetid = ?', [$data->id]);
            $data->eprepasc = R::findone('eprep', 'ivfsheetid = ? order by id asc limit 1', [$data->id]);
            $data->eprepdes = R::findone('eprep', 'ivfsheetid = ? order by id DESC limit 1', [$data->id]);
            $data->examinations = R::findone('examination', 'del = ? and patientid = ? order by id DESC limit 1', [0, $data->patientid]);
            $data->anprotocolt = R::load('icsiprotocol', $data->anprotocol);

        }

        $this->smarty->display('reports2/Ivfstatisticssearch.html');
    }

    public function showprint()
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //R::debug(TRUE);
        $fromdate = filter_input(INPUT_POST, 'fromdate');
        $todate = filter_input(INPUT_POST, 'todate');

        $fromdate = date("Y/m/d", strtotime($fromdate));
        $todate = date("Y/m/d", strtotime($todate));
        $today  = date("Y/m/d");
       $allData = R::findAll('ancsheet', 'sheetedd >= ? and sheetedd <= ?', [$fromdate, $todate]);
        $this->smarty->assign('allData', $allData);
        foreach ($allData as $data) {
            $data->info = R::load('patients', $data->patientid);
            $diff = strtotime($today, 0) - strtotime($data->sheetlmp, 0); 
           $tablenameappend->newvisitdate = $today;
           $ceil = ceil($diff / 604800);
           $data->week = abs($ceil);
        }
        $this->smarty->display('reports2/Ivfstatisticsprint.html');
    }

    public function onesetup()
    {

        //check login
        autho::checkautho($this->hosturl);

        try {
            //delete all but with only default
            #1 clean roles only managment
            #2 clean menu only default
            #3 clean controls only default
            #4 users clean users
            #delete all menus
            $menus = R::findAll('awmenu', 'id > 15');
            #delete from awrolemenu
            foreach ($menus as $one) {
                //get propes
                $rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
                R::trashAll($rolemenu);
            }
            R::trashAll($menus);
            #delete controles
            $controlls = R::findAll('awcontroll', 'id > 4 and id < 18');
            foreach ($controlls as $one) {
                //get propes
                $inprop = R::findAll('awcontrollprop', 'awcontroll_id = ?', [$one->id]);
                #delete from awrolecontroleprop
                foreach ($inprop as $one) {
                    //get propes
                    $roleprop = R::findAll('awrolecontrollprop', 'controllprop_id = ?', [$one->id]);
                    R::trashAll($roleprop);
                }
                R::trashAll($inprop);
            }
            R::trashAll($controlls);
            #delete othre roles
            $roles = R::findAll('awrole', 'id > 1');
            R::trashAll($roles);
            #delete other users
            //$users = R::findAll('awusers', 'user_id > 1');
            //R::exec('Delete from awusers where user_id > 1');
            //R::trashAll($users);
            ############################
            //new one
            $menusx = R::findAll('awmenu', ' id = 4 or id = 5 or id = 7 or id = 8 or id = 10 or id = 11 or id = 13 or id = 14 or id = 15 ');
            #delete from awrolemenu
            foreach ($menusx as $one) {
                //get propes
                $rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
                R::trashAll($rolemenu);
            }
            R::trashAll($menusx);

            print_r('trash all , install is good');
        } catch (Exception $ex) {
            print_r('something go wrong  , try again');
        }
    }

    // at the end of class call
    public function __destruct()
    {
        //close connection
        R::close();
    }

}
